#!/bin/sh
# Convert group name to lowercase and remove spaces and underscores
UNIXGROUP=`echo $1 | tr [:upper:] [:lower:] | tr -d '_ '`
NUMCHARS=`expr "$UNIXGROUP" : '.*'`
if [ "$UNIXGROUP" != "$1" -o $NUMCHARS -gt 8 ]
then
        # Windows group name includes invalid characters or is too long.
        exit 99
fi

# If the UNIX group does not exists, add the group
groupls -l $UNIXGROUP > /dev/null 2>&1
if [ $? -ne 0 ]
then
        groupadd $UNIXGROUP
fi

# Echo the GID
GID=`cat /etc/group | grep $UNIXGROUP | cut -d ":" -f3`
echo $GID

exit 0
