#!/bin/sh

# This script is called by Samba to create UNIX user accounts
# when importing Windows user accounts and machine accounts from
# a Primary Domain Controller

# Modify following variables as needed
USER_GROUP=users

# Locate the Samba configuration files
if [ -f /etc/samba/smb.conf ]
then
        # OpenServer
        ETCSAMBA=/etc/samba
else
        # UnixWare
        ETCSAMBA=/usr/lib/samba/private
fi
SMBUSERS_FILE=$ETCSAMBA/smbusers

UNIXUSER=`echo $1 | tr [:upper:] [:lower:] | tr -d '_ '`
NUMCHARS=`expr "$UNIXUSER" : '.*'`
if [ "$UNIXUSER" != "$1" -o $NUMCHARS -gt 8 ]
then
        echo Windows user name too long or includes invalid characters
        exit 99
fi

# If the UNIX user does not exists, add the user
userls -l $UNIXUSER > /dev/null 2>&1
if [ $? -ne 0 ]
then
        useradd -d /tmp -g $USER_GROUP -G $USER_GROUP -s /bin/false $UNIXUSER
fi

exit 0
