#!/bin/sh

if [ -f /bin/smbnet ]
then
        NET=/bin/smbnet
        NOGROUP=nogroup
else
        NET=/usr/lib/samba/bin/net
        NOGROUP=nobody
fi

$NET groupmap cleanup

# First assign well known domain global groups
groupadd users
$NET groupmap modify ntgroup="Domain Admins" unixgroup=root
$NET groupmap modify ntgroup="Domain Users"  unixgroup=users
$NET groupmap modify ntgroup="Domain Guests" unixgroup=$NOGROUP

# Add the group for the machine accounts
groupadd machines
$NET groupmap add ntgroup="Domain Controllers" unixgroup=machines type=d rid=515
$NET groupmap add ntgroup="Domain Computers" unixgroup=machines type=d rid=516

# Add other Windows 2000 specific groups
$NET groupmap add ntgroup="Cert Publishers" unixgroup=$NOGROUP type=d rid=518
$NET groupmap add ntgroup="Schema Admins" unixgroup=$NOGROUP type=d rid=519
$NET groupmap add ntgroup="Enterprise Admins" unixgroup=$NOGROUP type=d rid=520

# Assign builtin local groups
$NET groupmap modify ntgroup="Administrators" unixgroup=root
$NET groupmap modify ntgroup="Users" unixgroup=users
$NET groupmap modify ntgroup="Guests" unixgroup=$NOGROUP

# Now create the operator groups, including the associated UNIX group
groupadd operator
$NET groupmap modify ntgroup="Account Operators" unixgroup=operator
$NET groupmap modify ntgroup="System Operators" unixgroup=operator
$NET groupmap modify ntgroup="Print Operators" unixgroup=operator
$NET groupmap modify ntgroup="Backup Operators" unixgroup=operator
$NET groupmap modify ntgroup="Replicators" unixgroup=operator

# Finally, add any of your own domain global and local groups
# groupadd engineer
# $NET groupmap add ntgroup="Engineering Team" unixgroup=engineer type=d rid=1114

$NET groupmap list

